﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="System" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Ksiega.Reports" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Informacja o zobowiązaniach podatkowych</title>
	<script runat="server">
        private void OnContextLoad(object sender, EventArgs e)
		{
            var helper = new WydrukZobowiazanPodatkowychHelper(dc.Context);
	        GridVat.DataSource = helper.VatList;
	        GridPit.DataSource = helper.PitList;
	        GridCit.DataSource = helper.CitList;
	        GridZus.DataSource = helper.ZusDraList;
            ScVat.Visible = helper.VatList.Count > 0;
	        ScPit.Visible = helper.PitList.Count > 0;
	        ScCit.Visible = helper.CitList.Count > 0;
	        ScZus.Visible = helper.ZusDraList.Count > 0;
            ReportHeader.Title = helper.DBItem.FirmName + " | Informacja o obliczeniach: " + helper.DBItem.CalculatedProperties.LastCalculationInfo;
        }
    </script>
    <style type="text/css">
        h2 {
            font: bold 10pt Tahoma, sans-serif;
            padding: 1em 0 0.2em 10%;
        }
    </style>
</head>
<body>
    <form runat="server">
		<ea:DataContext id="dc" runat="server" OnContextLoad="OnContextLoad" />
		<eb:ReportHeader id="ReportHeader" runat="server" />
        <ea:Section id="ScVat" runat="server">
            <h2>VAT</h2>
            <ea:grid id="GridVat" runat="server" RowsInRow="2" RowTypeName="Soneta.Ksiega.Reports.WydrukZobowiazanPodatkowychHelper.VatItem">
                <Columns>
                    <ea:GridColumn DataMember="Deklaracja" Caption="Deklaracja"></ea:GridColumn>
                    <ea:GridColumn DataMember="eDeklaracjaStatus" Caption="eDeklaracja"></ea:GridColumn>
                    <ea:GridColumn DataMember="ZaMiesiac" Caption="Za miesiąc" Align="Center" RowSpan="2"></ea:GridColumn>
                    <ea:GridColumn DataMember="Korekta" Caption="Korekta" Align="Center" RowSpan="2"></ea:GridColumn>
                    <ea:GridColumn DataMember="VatNalezny" Caption="VAT należny" Align="Right" Format="{0:n}"></ea:GridColumn>
                    <ea:GridColumn DataMember="VatNaliczony" Caption="VAT naliczony" Align="Right" Format="{0:n}"></ea:GridColumn>
                    <ea:GridColumn DataMember="DoPrzeniesienia" Caption="Do przeniesienia" Align="Right" Format="{0:n}" RowSpan="2"></ea:GridColumn>
                    <ea:GridColumn DataMember="DoZaplaty" Caption="Do zapłaty" Align="Right" Format="{0:n}" RowSpan="2" Total="Sum"></ea:GridColumn>
                </Columns>
            </ea:grid>
        </ea:Section>
        <ea:Section id="ScPit" runat="server">
            <h2>Podatek dochodowy - PIT</h2>
            <ea:grid id="GridPit" runat="server" RowsInRow="2" RowTypeName="Soneta.Ksiega.Reports.WydrukZobowiazanPodatkowychHelper.PitItem">
                <Columns>
                    <ea:GridColumn DataMember="Deklaracja" Caption="Rodzaj zaliczki" RowSpan="2"></ea:GridColumn>
                    <ea:GridColumn DataMember="ZaMiesiac" Caption="Za miesiąc" Align="Center" RowSpan="2"></ea:GridColumn>
                    <ea:GridColumn DataMember="Wlasciciel" Caption="Właściciel" RowSpan="2"></ea:GridColumn>
                    <ea:GridColumn DataMember="Przychod" Caption="Przychód" Align="Right" Format="{0:n}"></ea:GridColumn>
                    <ea:GridColumn DataMember="Koszty" Caption="Koszty" Align="Right" Format="{0:n}"></ea:GridColumn>
                    <ea:GridColumn DataMember="Dochod" Caption="Dochód/Strata" Align="Right" Format="{0:n}" RowSpan="2"></ea:GridColumn>
                    <ea:GridColumn DataMember="DoZaplaty" Caption="Do zapłaty" Align="Right" Format="{0:n}" RowSpan="2" Total="Sum"></ea:GridColumn>
                </Columns>
            </ea:grid>   
        </ea:Section>
        <ea:Section id="ScCit" runat="server">
            <h2>Podatek dochodowy - CIT</h2>
            <ea:grid id="GridCit" runat="server" RowsInRow="2" RowTypeName="Soneta.Ksiega.Reports.WydrukZobowiazanPodatkowychHelper.CitItem">
                <Columns>                
                    <ea:GridColumn DataMember="Deklaracja" Caption="Rodzaj zaliczki" RowSpan="2"></ea:GridColumn>
                    <ea:GridColumn DataMember="ZaMiesiac" Caption="Za miesiąc" Align="Center" RowSpan="2"></ea:GridColumn>
                    <ea:GridColumn DataMember="Przychod" Caption="Przychód" Align="Right" Format="{0:n}"></ea:GridColumn>
                    <ea:GridColumn DataMember="Koszty" Caption="Koszty" Align="Right" Format="{0:n}"></ea:GridColumn>
                    <ea:GridColumn DataMember="Dochod" Caption="Dochód/Strata" Align="Right" Format="{0:n}" RowSpan="2"></ea:GridColumn>
                    <ea:GridColumn DataMember="DoZaplaty" Caption="Do zapłaty" Align="Right" Format="{0:n}" RowSpan="2" Total="Sum"></ea:GridColumn>
                </Columns>
            </ea:grid>
        </ea:Section>
        <ea:Section id="ScZus" runat="server">
            <h2>ZUS - DRA</h2>
            <ea:grid id="GridZus" runat="server" RowsInRow="1" RowTypeName="Soneta.Ksiega.Reports.WydrukZobowiazanPodatkowychHelper.ZusDraItem">
                <Columns>
                    <ea:GridColumn DataMember="Wlasciciel" Caption="Właściciel"></ea:GridColumn>
                    <ea:GridColumn DataMember="Spoleczne" Caption="Społeczne" Align="Right" Format="{0:n}"></ea:GridColumn>
                    <ea:GridColumn DataMember="Zdrowotne" Caption="Zdrowotne" Align="Right" Format="{0:n}"></ea:GridColumn>
                    <ea:GridColumn DataMember="FgiFgsp" Caption="FG i FGSP" Align="Right" Format="{0:n}"></ea:GridColumn>
                    <ea:GridColumn DataMember="Fep" Caption="FEP" Align="Right" Format="{0:n}"></ea:GridColumn>
                    <ea:GridColumn DataMember="Razem" Caption="Do zapłaty" Align="Right" Format="{0:n}" Total="Sum"></ea:GridColumn>
                </Columns>
            </ea:grid>
        </ea:Section>
		<eb:ReportFooter id="ReportFooter" runat="server" />		
	</form>
</body>
</html>

